/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Util {
    public static final int JVM_UNDEFINED = 0;
    public static final int JVM_MS = 1;
    public static final int JVM_NETSCAPE = 2;
    public static final int JVM_UNKNOWN = 3;
    public static int jvmType = 0;
    private static Object[] jvmData;
    private static Method assertPermission;
    protected static final String HEX_CHARS = "0123456789ABCDEF";

    public static int[] arrayInsert(int[] source, int start, int count, int value) {
        int[] result;
        if (count <= 0) {
            result = new int[source.length];
            System.arraycopy(source, 0, result, 0, source.length);
        } else {
            int rem;
            result = new int[source.length + count];
            if (start > 0) {
                System.arraycopy(source, 0, result, 0, start);
            }
            if ((rem = source.length - start) > 0) {
                System.arraycopy(source, start, result, start + count, rem);
            }
            for (int i = start; i < start + count; ++i) {
                result[i] = value;
            }
        }
        return result;
    }

    public static int[] arrayDelete(int[] source, int start, int count) {
        int[] result;
        if (count <= 0) {
            result = new int[source.length];
            System.arraycopy(source, 0, result, 0, source.length);
        } else {
            result = new int[source.length - count];
            if (start > 0) {
                System.arraycopy(source, 0, result, 0, start);
            }
            if (start + count < source.length) {
                System.arraycopy(source, start + count, result, start, source.length - (start + count));
            }
        }
        return result;
    }

    public static int random(int n) {
        double decimal = Math.random();
        int value = (int)Math.round(decimal * (double)n);
        return value;
    }

    public static boolean isWindows() {
        String OS2 = System.getProperty("os.name");
        return OS2.toLowerCase().indexOf("win") >= 0;
    }

    public static Object secureMethod(Class cl, String methodName, Class[] paramTypes, Object instance, Object[] params) throws Exception {
        return Util.secureExecute(cl.getMethod(methodName, paramTypes), instance, params);
    }

    public static Object secureConstructor(Class cl, Class[] paramTypes, Object[] params) throws Exception {
        return Util.secureExecute(cl.getConstructor(paramTypes), null, params);
    }

    private static Object secureExecute(Object routine, Object instance, Object[] params) throws Exception {
        switch (Util.determineJVM()) {
            case 1: {
                for (int i = 0; i < jvmData.length; ++i) {
                    assertPermission.invoke(null, jvmData[i]);
                }
                break;
            }
        }
        try {
            if (routine instanceof Method) {
                return ((Method)routine).invoke(instance, params);
            }
            return ((Constructor)routine).newInstance(params);
        }
        catch (InvocationTargetException i) {
            System.out.println("InvocationTarget Exception in secureExecute");
            Throwable t = i.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw i;
        }
    }

    public static int determineJVM() {
        if (jvmType == 0) {
            block10: {
                block9: {
                    try {
                        if (Class.forName("com.ms.security.PermissionUtils") != null) {
                            jvmData = new Object[4];
                            Class<?> pi = Class.forName("com.ms.security.PermissionID");
                            Util.jvmData[0] = pi.getField("SYSTEM").get(null);
                            Util.jvmData[1] = pi.getField("FILEIO").get(null);
                            Util.jvmData[2] = pi.getField("UI").get(null);
                            Util.jvmData[3] = pi.getField("PROPERTY").get(null);
                            Class<?> pe = Class.forName("com.ms.security.PolicyEngine");
                            assertPermission = pe.getMethod("assertPermission", pi);
                            jvmType = 1;
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof ClassNotFoundException) break block9;
                        t.printStackTrace();
                    }
                }
                if (jvmType == 0) {
                    try {
                        if (Class.forName("netscape.security.AppletSecurity") != null) {
                            jvmType = 2;
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof ClassNotFoundException) break block10;
                        t.printStackTrace();
                    }
                }
            }
            if (jvmType == 0) {
                jvmType = 3;
            }
        }
        return jvmType;
    }

    public static int[] ensureArraySize(int[] source, int size, int value) {
        int[] result = source;
        if (result.length < size) {
            result = Util.arrayInsert(result, result.length, size - result.length, value);
        } else if (result.length > size) {
            result = Util.arrayDelete(result, size, result.length - size);
        }
        return result;
    }

    public static double[] arrayInsert(double[] source, int start, int count, double value) {
        double[] result;
        if (count <= 0) {
            result = new double[source.length];
            System.arraycopy(source, 0, result, 0, source.length);
        } else {
            int rem;
            result = new double[source.length + count];
            if (start > 0) {
                System.arraycopy(source, 0, result, 0, start);
            }
            if ((rem = source.length - start) > 0) {
                System.arraycopy(source, start, result, start + count, rem);
            }
            for (int i = start; i < start + count; ++i) {
                result[i] = value;
            }
        }
        return result;
    }

    public static double[] arrayDelete(double[] source, int start, int count) {
        double[] result;
        if (count <= 0) {
            result = new double[source.length];
            System.arraycopy(source, 0, result, 0, source.length);
        } else {
            result = new double[source.length - count];
            if (start > 0) {
                System.arraycopy(source, 0, result, 0, start);
            }
            if (start + count < source.length) {
                System.arraycopy(source, start + count, result, start, source.length - (start + count));
            }
        }
        return result;
    }

    public static double[] ensureArraySize(double[] source, int size, double value) {
        double[] result = source;
        if (result.length < size) {
            result = Util.arrayInsert(result, result.length, size - result.length, value);
        } else if (result.length > size) {
            result = Util.arrayDelete(result, size, result.length - size);
        }
        return result;
    }

    public static Object[] arrayInsert(Object[] source, int start, int count, Object value) {
        Object[] result = source;
        if (count > 0) {
            int rem;
            result = (Object[])Array.newInstance(source.getClass().getComponentType(), source.length + count);
            if (start > 0) {
                System.arraycopy(source, 0, result, 0, start);
            }
            if ((rem = source.length - start) > 0) {
                System.arraycopy(source, start, result, start + count, rem);
            }
            for (int i = start; i < start + count; ++i) {
                result[i] = value;
            }
        }
        return result;
    }

    public static Object[] arrayDelete(Object[] source, int start, int count) {
        Object[] result;
        if (count <= 0) {
            result = new Object[source.length];
            System.arraycopy(source, 0, result, 0, source.length);
        } else {
            result = new Object[source.length - count];
            if (start > 0) {
                System.arraycopy(source, 0, result, 0, start);
            }
            if (start + count < source.length) {
                System.arraycopy(source, start + count, result, start, source.length - (start + count));
            }
        }
        return result;
    }

    public static Object[] arrayDeleteElement(Object[] source, Object element) {
        for (int i = 0; i < source.length; ++i) {
            if (source[i] != element) continue;
            return Util.arrayDelete(source, i, 1);
        }
        return source;
    }

    public static boolean getBoolean(Object source, boolean defValue) {
        if (source instanceof String) {
            return "TRUE".equals(source = ((String)source).toUpperCase()) || "T".equals(source) || "YES".equals(source) || "Y".equals(source) || "1".equals(source);
        }
        if (source instanceof Boolean) {
            return (Boolean)source;
        }
        return defValue;
    }

    public static boolean getBoolean(Object source) {
        if (source instanceof String) {
            return "TRUE".equals(source = ((String)source).toUpperCase()) || "T".equals(source) || "YES".equals(source) || "Y".equals(source) || "1".equals(source);
        }
        if (source instanceof Boolean) {
            return (Boolean)source;
        }
        return false;
    }

    public static char getChar(Object source, char defValue) {
        if (source instanceof String) {
            String str = (String)source;
            return str.length() == 0 ? defValue : str.charAt(0);
        }
        if (source instanceof Character) {
            return ((Character)source).charValue();
        }
        return defValue;
    }

    public static double getDouble(Object source) {
        return Util.getDouble(source, 0.0);
    }

    public static double getDouble(Object source, double defValue) {
        if (source instanceof String) {
            try {
                return Double.valueOf((String)source);
            }
            catch (Exception e) {
                return defValue;
            }
        }
        if (source instanceof Number) {
            return ((Number)source).doubleValue();
        }
        return defValue;
    }

    public static long getLong(Object source) {
        return Util.getLong(source, 0L);
    }

    public static long getLong(Object source, long defValue) {
        if (source instanceof String) {
            try {
                return Long.parseLong((String)source);
            }
            catch (Exception exception) {
            }
        } else if (source instanceof Number) {
            return ((Number)source).longValue();
        }
        return defValue;
    }

    public static Class findClass(String packageName, String className) {
        Class<?> result;
        if (className.indexOf(46) == -1) {
            className = packageName + "." + className;
        }
        try {
            result = Class.forName(className);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static String hex(byte value) {
        return "" + HEX_CHARS.charAt((value & 0xF0) >> 4) + HEX_CHARS.charAt(value & 0xF);
    }

    public static String hex(short value) {
        return Util.hex((byte)(value >> 8)) + Util.hex((byte)value);
    }

    public static String hex(int value) {
        return Util.hex((short)(value >> 16)) + Util.hex((short)value);
    }

    public static String dumpBytes(byte[] buffer) {
        return Util.dumpBytes(buffer, 0, buffer.length, true, true, true);
    }

    public static String dumpBytes(byte[] buffer, int start) {
        return Util.dumpBytes(buffer, 0, buffer.length, true, true, true, start);
    }

    public static String dumpBytes(int[] buffer) {
        return Util.dumpBytes(buffer, 0, buffer.length, true, true, true);
    }

    public static String dumpBytes(byte[] buffer, int offset, int length, boolean showAddr, boolean showChars, boolean lineFeed) {
        StringBuilder buff = new StringBuilder(80 * ((length += offset) + 15) / 16);
        for (int i = offset; i < length; i += 16) {
            int j;
            String end = "; ";
            if (showAddr) {
                buff.append(Util.hex(i)).append(": ");
            }
            for (j = 0; j < 16 && i + j < length; ++j) {
                byte data = buffer[i + j];
                buff.append(Util.hex(data)).append(" ");
                end = end + (data >= 32 && data < 127 ? (char)data : (char)'.');
            }
            while (j < 16) {
                buff.append("   ");
                ++j;
            }
            if (showChars) {
                buff.append(end);
            }
            if (!lineFeed) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    public static String dumpBytes(byte[] buffer, int offset, int length) {
        return Util.dumpBytes(buffer, offset, length, true, true, true);
    }

    public static String dumpBytes(byte[] buffer, int offset, int length, boolean showAddr, boolean showChars, boolean lineFeed, int start) {
        StringBuilder buff = new StringBuilder(80 * ((length += offset) + 15) / 16);
        for (int i = offset; i < length; i += 16) {
            int j;
            String end = "; ";
            if (showAddr) {
                buff.append(Util.hex(i + start)).append(": ");
            }
            for (j = 0; j < 16 && i + j < length; ++j) {
                byte data = buffer[i + j];
                buff.append(Util.hex(data)).append(" ");
                end = end + (data >= 32 && data < 127 ? (char)data : (char)'.');
            }
            while (j < 16) {
                buff.append("   ");
                ++j;
            }
            if (showChars) {
                buff.append(end);
            }
            if (!lineFeed) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    public static String dumpBytes(int[] buffer, int offset, int length, boolean showAddr, boolean showChars, boolean lineFeed) {
        StringBuilder buff = new StringBuilder(80 * ((length += offset) + 15) / 16);
        for (int i = offset; i < length; i += 16) {
            int j;
            String end = "; ";
            if (showAddr) {
                buff.append(Util.hex(i)).append(": ");
            }
            for (j = 0; j < 16 && i + j < length; ++j) {
                byte data = (byte)buffer[i + j];
                buff.append(Util.hex(data)).append(" ");
                end = end + (data >= 32 && data < 127 ? (char)data : (char)'.');
            }
            while (j < 16) {
                buff.append("   ");
                ++j;
            }
            if (showChars) {
                buff.append(end);
            }
            if (!lineFeed) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    public static byte hexValue(char value) {
        if (value >= 'a') {
            return (byte)(value - 97 + 10);
        }
        if (value > '9') {
            return (byte)(value - 65 + 10);
        }
        return (byte)(value - 48);
    }

    public static int hexValue(String source) throws Exception {
        int result = 0;
        source = source.trim();
        for (int i = 0; i < source.length(); ++i) {
            byte val = Util.hexValue(source.charAt(i));
            if (val < 0 || val > 15) {
                throw new Exception("Illegal hex character in " + source);
            }
            result = (result << 4) + val;
        }
        return result;
    }
}

